float3 amg_AbsLerp(float3 a, float3 b, float t)
{
	return a * saturate(1.0f - t) + b * t;
}
float4 amg_AbsLerp(float4 a, float4 b, float t)
{
	return a * saturate(1.0f - t) + b * t;
}

static float3 cie_colour_match[81] = {
	{ 0.0014f,0.0000f,0.0065f },{ 0.0022f,0.0001f,0.0105f },{ 0.0042f,0.0001f,0.0201f },
	{ 0.0076f,0.0002f,0.0362f },{ 0.0143f,0.0004f,0.0679f },{ 0.0232f,0.0006f,0.1102f },
	{ 0.0435f,0.0012f,0.2074f },{ 0.0776f,0.0022f,0.3713f },{ 0.1344f,0.0040f,0.6456f },
	{ 0.2148f,0.0073f,1.0391f },{ 0.2839f,0.0116f,1.3856f },{ 0.3285f,0.0168f,1.6230f },
	{ 0.3483f,0.0230f,1.7471f },{ 0.3481f,0.0298f,1.7826f },{ 0.3362f,0.0380f,1.7721f },
	{ 0.3187f,0.0480f,1.7441f },{ 0.2908f,0.0600f,1.6692f },{ 0.2511f,0.0739f,1.5281f },
	{ 0.1954f,0.0910f,1.2876f },{ 0.1421f,0.1126f,1.0419f },{ 0.0956f,0.1390f,0.8130f },
	{ 0.0580f,0.1693f,0.6162f },{ 0.0320f,0.2080f,0.4652f },{ 0.0147f,0.2586f,0.3533f },
	{ 0.0049f,0.3230f,0.2720f },{ 0.0024f,0.4073f,0.2123f },{ 0.0093f,0.5030f,0.1582f },
	{ 0.0291f,0.6082f,0.1117f },{ 0.0633f,0.7100f,0.0782f },{ 0.1096f,0.7932f,0.0573f },
	{ 0.1655f,0.8620f,0.0422f },{ 0.2257f,0.9149f,0.0298f },{ 0.2904f,0.9540f,0.0203f },
	{ 0.3597f,0.9803f,0.0134f },{ 0.4334f,0.9950f,0.0087f },{ 0.5121f,1.0000f,0.0057f },
	{ 0.5945f,0.9950f,0.0039f },{ 0.6784f,0.9786f,0.0027f },{ 0.7621f,0.9520f,0.0021f },
	{ 0.8425f,0.9154f,0.0018f },{ 0.9163f,0.8700f,0.0017f },{ 0.9786f,0.8163f,0.0014f },
	{ 1.0263f,0.7570f,0.0011f },{ 1.0567f,0.6949f,0.0010f },{ 1.0622f,0.6310f,0.0008f },
	{ 1.0456f,0.5668f,0.0006f },{ 1.0026f,0.5030f,0.0003f },{ 0.9384f,0.4412f,0.0002f },
	{ 0.8544f,0.3810f,0.0002f },{ 0.7514f,0.3210f,0.0001f },{ 0.6424f,0.2650f,0.0000f },
	{ 0.5419f,0.2170f,0.0000f },{ 0.4479f,0.1750f,0.0000f },{ 0.3608f,0.1382f,0.0000f },
	{ 0.2835f,0.1070f,0.0000f },{ 0.2187f,0.0816f,0.0000f },{ 0.1649f,0.0610f,0.0000f },
	{ 0.1212f,0.0446f,0.0000f },{ 0.0874f,0.0320f,0.0000f },{ 0.0636f,0.0232f,0.0000f },
	{ 0.0468f,0.0170f,0.0000f },{ 0.0329f,0.0119f,0.0000f },{ 0.0227f,0.0082f,0.0000f },
	{ 0.0158f,0.0057f,0.0000f },{ 0.0114f,0.0041f,0.0000f },{ 0.0081f,0.0029f,0.0000f },
	{ 0.0058f,0.0021f,0.0000f },{ 0.0041f,0.0015f,0.0000f },{ 0.0029f,0.0010f,0.0000f },
	{ 0.0020f,0.0007f,0.0000f },{ 0.0014f,0.0005f,0.0000f },{ 0.0010f,0.0004f,0.0000f },
	{ 0.0007f,0.0002f,0.0000f },{ 0.0005f,0.0002f,0.0000f },{ 0.0003f,0.0001f,0.0000f },
	{ 0.0002f,0.0001f,0.0000f },{ 0.0002f,0.0001f,0.0000f },{ 0.0001f,0.0000f,0.0000f },
	{ 0.0001f,0.0000f,0.0000f },{ 0.0001f,0.0000f,0.0000f },{ 0.0000f,0.0000f,0.0000f }
};

float3x3 XYZtoRGB = { { 3.2404542f, -1.5371385f, -0.4985314f }, { -0.9692660f, 1.8760108f, 0.0415560f }, { 0.0556434f, -0.2040259f, 1.0572252f } };

float3 wavelength_color(float lambda_nm)
{
	float ii = (lambda_nm - 380.0f) / 5.0f;
	int i = (int)ii;
	if (i < 0 || i >= 80)
		return (float3)0.f;

	float3 xyz_color = lerp(cie_colour_match[i], cie_colour_match[i+1], ii - i);

    // From OSL sourcecode comes this line in wavelength_color (including the comment)
    //
    //    rgb *= 1.0 / 2.52;    // Empirical scale from lg to make all comps <= 1
    //
    // So the divide by 2.52 is completely arbitrary by Larry - but it's what OSL does so.... :)
    // It also clamps it to avoid negative values

	return saturate(mul(XYZtoRGB, xyz_color) / 2.52); 
}

float spec_intens(float wavelength_nm, float temp)
{
	static const float c1 = 3.74183e-16f;
	static const float c2 = 1.4388e-2f;

	float wlm = wavelength_nm * 1e-9f;
	return (c1 * pow(wlm, -5.f)) / (exp(c2 / (wlm * temp)) - 1.f);
}

float3 blackbody_rgb(float T)
{
	if (T < 800.f)
		return float3(1.0e-6f, 0.f, 0.f);

	static const float dlambda = 5.f * 1e-9f;
	static const int step = 9;

	float3 bb = (float3)0.f;
	[unroll] for (int i = 0; i < 81; i += step)
	{
		float lambda = 380.f + 5.f * i;
		float Me = spec_intens(lambda, T) * dlambda;
		bb += cie_colour_match[i] * Me * step;
	}
	
	float3 rgb = mul(XYZtoRGB, bb);
	return max(rgb, (float3)0.f);
}

// To RGB conversions

float3 hsv_to_rgb(float3 hsv)
{
    float h = hsv.r, s = hsv.g, v = hsv.b;

    float3 r;
    if (s < 0.0001f)
    {
        r = (float3)v;
    }
    else
    {
        h = 6 * (h - floor(h));
        int hi = (int)h;

        float f = h - hi;
        float p = v * (1 - s);
        float q = v * (1 - s * f);
        float t = v * (1 - s * (1 - f));

        if (hi == 0)	  r = float3(v, t, p);
        else if (hi == 1) r = float3(q, v, p);
        else if (hi == 2) r = float3(p, v, t);
        else if (hi == 3) r = float3(p, q, v);
        else if (hi == 4) r = float3(t, p, v);
        else              r = float3(v, p, q);
    }

    return r;
}

float3 hsl_to_rgb(float3 hsl) {
    float h = hsl.r, s = hsl.g, l = hsl.b;
    // Easiest to convert hsl -> hsv, then hsv -> RGB (per Foley & van Dam)
    float v = (l <= 0.5) ? (l * (1 + s)) : (l * (1 - s) + s);
    float3 r;
    if (v <= 0) {
        r = 0;
    }
    else {
        float min = 2 * l - v;
        s = (v - min) / v;
        r = hsv_to_rgb(float3(h, s, v));
    }
    return r;
}

float3 YIQ_to_rgb(float3 YIQ) {
    return float3(dot(float3(1, 0.9557, 0.6199),   YIQ),
                  dot(float3(1, -0.2716, -0.6469), YIQ),
                  dot(float3(1, -1.1082, 1.7051),  YIQ));
}

float3 XYZ_to_rgb(float3 XYZ) {
    return float3(dot(float3(3.240479, -1.537150, -0.498535), XYZ),
                  dot(float3(-0.969256, 1.875991, 0.041556),  XYZ),
                  dot(float3(0.055648, -0.204043, 1.057311),  XYZ));
}

// From RGB conversions

float3 rgb_to_hsv(float3 rgb) {  // See Foley & van Dam
    float r = rgb.r, g = rgb.g, b = rgb.b;
    float mincomp = min(r, min(g, b));
    float maxcomp = max(r, max(g, b));
    float delta = maxcomp - mincomp;  // chroma
    float h, s, v;
    v = maxcomp;
    if (maxcomp > 0)
        s = delta / maxcomp;
    else s = 0;
    if (s <= 0)
        h = 0;
    else {
        if (r >= maxcomp) h = (g - b) / delta;
        else if (g >= maxcomp) h = 2 + (b - r) / delta;
        else                   h = 4 + (r - g) / delta;
        h /= 6;
        if (h < 0)
            h += 1;
    }
    return float3(h, s, v);
}

float3 rgb_to_hsl(float3 rgb) {  // See Foley & van Dam
   // First convert rgb to hsv, then to hsl
    float  minval = min(rgb.r, min(rgb.g, rgb.b));
    float3 hsv = rgb_to_hsv(rgb);
    float maxval = hsv.b;   // v == maxval
    float h = hsv.r, s, l = (minval + maxval) / 2;
    if (minval == maxval)
        s = 0;  // special 'achromatic' case, hue is 0
    else if (l <= 0.5)
        s = (maxval - minval) / (maxval + minval);
    else
        s = (maxval - minval) / (2 - maxval - minval);
    return float3(h, s, l);
}

float3 rgb_to_YIQ(float3 rgb) {
    return float3(dot(float3(0.299, 0.587, 0.114),   rgb),
                  dot(float3(0.596, -0.275, -0.321), rgb),
                  dot(float3(0.212, -0.523, 0.311),  rgb));
}

float3 rgb_to_XYZ(float3 rgb) {
    return float3(dot(float3(0.412453, 0.357580, 0.180423), rgb),
                  dot(float3(0.212671, 0.715160, 0.072169), rgb),
                  dot(float3(0.019334, 0.119193, 0.950227), rgb));
}

#define AMGMADD(a, b, c) ((a)*(b) + (c))

float fast_erf(float x)
{
    const float a1 = 0.0705230784f;
    const float a2 = 0.0422820123f;
    const float a3 = 0.0092705272f;
    const float a4 = 0.0001520143f;
    const float a5 = 0.0002765672f;
    const float a6 = 0.0000430638f;
    const float a = abs(x);
    const float b = 1.0f - (1.0f - a); // crush denormals
    const float r = AMGMADD(AMGMADD(AMGMADD(AMGMADD(AMGMADD(AMGMADD(a6, b, a5), b, a4), b, a3), b, a2), b, a1), b, 1.0f);
    const float s = r * r; // ^2
    const float t = s * s; // ^4
    const float u = t * t; // ^8
    const float v = u * u; // ^16

    float res = abs(1.0f - 1.0f / v);
    return x > 0 ? res : -res;
}

inline float fast_expm1(float x) {
    if (abs(x) < 1e-5f) {
        x = 1.0f - (1.0f - x); // crush denormals
        return AMGMADD(0.5f, x*x, x);
    }
    else
        return exp(x) - 1.0f;
}
